#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{
	[TestFixture]
	public class DAL_OutgoingShipment : BaseTest 
	{
		private DataTable _dtShipment;
		private DataTable _dtBloodUnit;

		// ADDED 11/24/2004 RDH
		private DataTable _dtBloodUnitFinance;

		// ADDED 12/16/2004 RDH
		private DataTable _dtBloodUnitShipment;
		
		
		private DataTable _dtLocalSupplier;

		private string _baseQuery = string.Concat(	"SELECT TOP 1 BU.*, BUSCC.UnitStatusCode, BUS.RowVersion AS 'UnitStatusRowVersion' ",
			"FROM vw_BloodShipAllCurrent BU ",
			"JOIN BloodUnitStatus BUS ON BUS.BloodUnitGuid = BU.BloodUnitGuid ",
			"JOIN BloodUnitStatusCodeCurrent BUSCC ON BUSCC.BloodUnitGuid = BU.BloodUnitGuid ",
			"WHERE OutgoingShipmentGuid IN (SELECT ShipmentGuid FROM Shipment WHERE ShipmentDate IS NOT NULL) ",
			"AND BU.RecordStatusCode = 'A' ",
			"AND BU.DivisionCode = '", UnitTestConfig.TestDivisionCode, "'" );

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();

			if (this.RefreshData)
			{
				// UPDATED 11/24/2004 RDH, added BUS.RowVersion
				//*******BloodUnit
				this._dtBloodUnit = UnitTestUtil.RunSQLGetDataTable(_baseQuery, false);
				if (this._dtBloodUnit.Rows.Count == 0)
				{
					BOL.BloodUnit tmpXUnit = DataCreator.CreateBloodUnit(true);
					string invoiceNumber = new Random().Next(111111111,999999999).ToString();
					BOL.LocalSupplier tmpLS = DataCreator.CreateLocalSupplier();
					BOL.OutgoingShipmentCollection tmpOSC = BOL.OutgoingShipmentCollection.CreateOutgoingInvoice(invoiceNumber, tmpLS.LocalSupplierGuid, DateTime.Now, Common.ShipmentType.ReturnToSupplier, Common.LogonUser.LogonUserName, Common.UpdateFunction.UnitTests);
					BOL.OutgoingShipmentCollection.LineItem lineItem = BOL.OutgoingShipmentCollection.LineItem.GetLineItemForUpdate(tmpXUnit.BloodUnitGuid);
					tmpOSC.AddUnitToInvoice(lineItem);
					tmpOSC.SaveChangesToInvoiceItems(new ArrayList(), Common.UpdateFunction.UnitTests);			//unit is not X, confirmation pending 
					DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.UnitLogout);
					tmpOSC.ConfirmShipment(DateTime.Now, Common.UpdateFunction.UnitTests, Common.WorkloadProcessID.UnitLogout);	//This puts the unit in X

					this._dtBloodUnit = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 BU.*, BUS.UnitStatusCode, BUS.RowVersion AS 'UnitStatusRowVersion' FROM vw_BloodShipAllCurrent BU JOIN BloodUnitStatus BUS ON BUS.BloodUnitGuid = BU.BloodUnitGuid WHERE OutgoingShipmentGuid IN (SELECT ShipmentGuid FROM Shipment WHERE ShipmentDate IS NOT NULL) AND BU.RecordStatusCode = 'A' AND BU.DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'", true);
				}

				// ADDED 11/24/2004 RDH
				//*******BloodUnitFinance
				this._dtBloodUnitFinance = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodUnitFinance WHERE BloodUnitGuid = '" + this._dtBloodUnit.Rows[0][TABLES.BloodUnit.BloodUnitGuid].ToString() + "'" , true);

				//**Shipment
				this._dtShipment = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM Shipment WHERE ShipmentGuid = '" + this._dtBloodUnit.Rows[0][TABLES.BloodUnitShipment.OutgoingShipmentGuid].ToString() + "'", true);

				// Added 12/16/2004
				//this._dtBloodUnitShipment = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM Shipment WHERE ShipmentGuid = '" + this._dtShipment.Rows[0]["ShipmentGuid"].ToString() + "'", true);
				this._dtBloodUnitShipment = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodUnitShipment WHERE OutgoingShipmentGuid = '" + this._dtBloodUnit.Rows[0][TABLES.BloodUnitShipment.OutgoingShipmentGuid].ToString() + "'", true);
				
				//*******LocalSupplier
				this._dtLocalSupplier = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM LocalSupplier WHERE DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'", false);
				if (this._dtLocalSupplier.Rows.Count == 0)
				{
					DataCreator.CreateLocalSupplier();
					this._dtLocalSupplier = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM LocalSupplier WHERE DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'", true);
				}

				this.RefreshData = false;
			}

		}

		[Test]
		public void ConfirmShipment_Pass()
		{
			this.RefreshData = true;

			System.DateTime shipDate = System.DateTime.Now;
			Guid shipmentGuid = (Guid)this._dtBloodUnit.Rows[0][TABLES.BloodUnitShipment.OutgoingShipmentGuid];
			
			byte[] ShipmentRowVersion = (byte[])this._dtShipment.Rows[0][TABLES.BloodUnitShipment.RowVersion];
			byte[] UnitStatusRowVersion = (byte[])this._dtBloodUnit.Rows[0]["UnitStatusRowVersion"];
			byte[] UnitRowVersion = (byte[])this._dtBloodUnit.Rows[0][TABLES.BloodUnit.RowVersion];

			DataTable dtWorkload = SprocHelper.GetInsertWorkloadEventsSprocTable();
			DataTable dtBloodUnit = SprocHelper.GetConfirmOutgoingShipmentSprocTable(shipDate, shipmentGuid, UnitRowVersion);
			
			DataTable dtShipment = SprocHelper.GetConfirmOutgoingShipmentSprocTable(shipDate, shipmentGuid, ShipmentRowVersion);
			dtShipment.Columns.Add(Common.VbecsTables.Shipment.DivisionCode, typeof(string));
			dtShipment.Rows[0][Common.VbecsTables.Shipment.DivisionCode]=UnitTestConfig.TestDivisionCode; 

			dtWorkload.Rows.Clear();

			bool retValue = DAL.OutgoingShipment.ConfirmShipment(dtWorkload, dtBloodUnit, dtShipment,null);

			Assert.AreEqual(true, retValue, "ReturnValue");

		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ConfirmShipment_Fail()
		{
			this.RefreshData = true;

			DateTime shipDate = System.DateTime.Now;
			Guid shipmentGuid = Guid.NewGuid();
			
			//Empty byte arrays to cause the failure of the Confirmation.
			byte[] ShipmentRowVersion = new byte[0];
			byte[] UnitStatusRowVersion = new byte[0];
			byte[] UnitRowVersion = new byte[0];

			DataTable dtWorkload = SprocHelper.GetInsertWorkloadEventsSprocTable();
			DataTable dtBloodUnit = SprocHelper.GetConfirmOutgoingShipmentSprocTable(shipDate, shipmentGuid, UnitRowVersion);
			DataTable dtShipment = SprocHelper.GetConfirmOutgoingShipmentSprocTable(shipDate, shipmentGuid, ShipmentRowVersion);

			dtWorkload.Rows.Clear();

			bool retValue = DAL.OutgoingShipment.ConfirmShipment(dtWorkload, dtBloodUnit, dtShipment,null);

			Assert.AreEqual(true, retValue, "ReturnValue");

		}

		[Test]
		public void CreateOutgoingInvoice_Pass()
		{
			string invoiceNumber = new Random().Next(99999,int.MaxValue).ToString();
			Guid shipmentGuid = Guid.NewGuid();
			Guid localSupplierGuid = (Guid)this._dtLocalSupplier.Rows[0][TABLES.LocalSupplier.LocalSupplierGuid];
			DateTime shipDate = System.DateTime.Now;
			char shipmentTypeCode = '1';
			//
			Assert.AreEqual(0,DAL.OutgoingShipment.CreateOutgoingInvoice( shipmentGuid, localSupplierGuid, shipmentTypeCode, invoiceNumber, Common.LogonUser.LogonUserName, Common.UpdateFunction.UnitTests ), "Saved");
		}

		[Test]
		[ExpectedException(typeof(Common.DataAccessLayerException))]
		public void CreateOutgoingInvoice_Fail()
		{
			string invoiceNumber = string.Empty;
			Guid shipmentGuid = Guid.NewGuid();
			Guid localSupplierGuid = Guid.NewGuid();
			DateTime shipDate = System.DateTime.Now;
			char shipmentTypeCode = char.MaxValue;
			//
			Assert.IsTrue( DAL.OutgoingShipment.CreateOutgoingInvoice( shipmentGuid, localSupplierGuid, shipmentTypeCode, invoiceNumber, Common.LogonUser.LogonUserName, Common.UpdateFunction.UnitTests ) == 1 );
		}

		[Test]
		public void GetBloodUnitTestResultsForDivision_String_Int_String_Pass()
		{
			string resultText = string.Empty;
			int testTypeId = 0;

			DataTable dtTest = DAL.OutgoingShipment.GetBloodUnitTestResultsForDivision(UnitTestConfig.TestDivisionCode, testTypeId, resultText);

			Assert.AreEqual(7, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.BloodTestTypeId), TABLES.BloodUnitTest.BloodTestTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(Common.VbecsTables.BloodTestType.BloodTestName), Common.VbecsTables.BloodTestType.BloodTestName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.BloodUnitGuid), TABLES.BloodUnitTest.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.DivisionCode), TABLES.BloodUnitTest.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.TestDate), TABLES.BloodUnitTest.TestDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TestResult.TestResultText), TABLES.TestResult.TestResultText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TestResult.TestResultId), TABLES.TestResult.TestResultId);
		}

		[Test]
		public void GetBloodUnitTestResultsForDivision_String_Int_String_Fail()
		{
			string resultText = "KABOOM!";
			int testTypeId = int.MinValue;

			DataTable dtTest = DAL.OutgoingShipment.GetBloodUnitTestResultsForDivision(UnitTestConfig.TestDivisionCode, testTypeId, resultText);

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetBloodUnitTestResultsForDivision_String_Pass()
		{
			DataTable dtTest = DAL.OutgoingShipment.GetBloodUnitTestResultsForDivision(UnitTestConfig.TestDivisionCode);

			Assert.AreEqual(7, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.BloodTestTypeId), TABLES.BloodUnitTest.BloodTestTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(Common.VbecsTables.BloodTestType.BloodTestName), Common.VbecsTables.BloodTestType.BloodTestName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.BloodUnitGuid), TABLES.BloodUnitTest.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.DivisionCode), TABLES.BloodUnitTest.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.TestDate), TABLES.BloodUnitTest.TestDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TestResult.TestResultText), TABLES.TestResult.TestResultText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TestResult.TestResultId), TABLES.TestResult.TestResultId);
		}

		[Test]
		public void GetBloodUnitTestResultsForDivision_String_Fail()
		{
			DataTable dtTest = DAL.OutgoingShipment.GetBloodUnitTestResultsForDivision(string.Empty);

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetEligibleUnitsForDivision_Pass()
		{
			DataTable dtTest = DAL.OutgoingShipment.GetEligibleUnitsForDivision();

			Assert.AreEqual(39, dtTest.Columns.Count, "Columns.Count");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetEligibleUnitsForDivision_Fail()
		{
		}

		[Test]
		public void GetInvoiceText_Pass()
		{
			DataTable dtTest = DAL.OutgoingShipment.GetInvoiceText();

			Assert.AreEqual(1, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(Common.VbecsTables.VamcDivision.InvoiceTemplateText), Common.VbecsTables.VamcDivision.InvoiceTemplateText);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetInvoiceText_Fail()
		{
		}

		[Test]
		public void GetOutgoingInvoice_Pass()
		{
			string invoiceNumber = this._dtShipment.Rows[0][TABLES.Shipment.InvoiceNumber].ToString();
			Guid localSupplierGuid = (Guid)this._dtShipment.Rows[0][TABLES.Shipment.LocalSupplierGuid];
			System.DateTime shipmentDate = (System.DateTime)this._dtShipment.Rows[0][TABLES.Shipment.ShipmentDate];

			DataSet dsTest = DAL.OutgoingShipment.GetOutgoingInvoice(invoiceNumber, localSupplierGuid, shipmentDate, UnitTestConfig.TestDivisionCode);
			DataTable dtTest = dsTest.Tables[0];

			Assert.AreEqual(17, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Shipment.ShipmentGuid), TABLES.Shipment.ShipmentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Shipment.ShipmentDirection), TABLES.Shipment.ShipmentDirection);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Shipment.ShipmentDate), TABLES.Shipment.ShipmentDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Shipment.InvoiceNumber), TABLES.Shipment.InvoiceNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Shipment.DivisionCode), TABLES.Shipment.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Shipment.LastUpdateDate), TABLES.Shipment.LastUpdateDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Shipment.LastUpdateUser), TABLES.Shipment.LastUpdateUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Shipment.ShipmentTemperature), TABLES.Shipment.ShipmentTemperature);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Shipment.ShipmentTypeCode), TABLES.Shipment.ShipmentTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Shipment.RowVersion), TABLES.Shipment.RowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.LocalSupplier.FacilityName), TABLES.LocalSupplier.FacilityName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Address.AddressCity), TABLES.Address.AddressCity);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Address.StateCode), TABLES.Address.StateCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.LocalSupplier.LocalSupplierGuid), TABLES.LocalSupplier.LocalSupplierGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.LocalSupplier.FdaRegistrationNumber), TABLES.LocalSupplier.FdaRegistrationNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.LocalSupplier.PhoneNumber), TABLES.LocalSupplier.PhoneNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.LocalSupplier.FaxNumber), TABLES.LocalSupplier.FaxNumber);
		}

		[Test]
		public void GetOutgoingInvoice_Fail()
		{
			string invoiceNumber = string.Empty;
			Guid localSupplierGuid = Guid.NewGuid();
			System.DateTime shipmentDate = System.DateTime.Now;

			DataSet dsTest = DAL.OutgoingShipment.GetOutgoingInvoice(invoiceNumber, localSupplierGuid, shipmentDate, UnitTestConfig.TestDivisionCode);
			DataTable dtTest = dsTest.Tables[0];

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetOutgoingInvoiceByGuid_Pass()
		{
			Guid shipmentGuid = (Guid)this._dtShipment.Rows[0][TABLES.Shipment.ShipmentGuid];

			DataSet dsTest = DAL.OutgoingShipment.GetOutgoingInvoiceByGuid(shipmentGuid);
			DataTable dtTest = dsTest.Tables[0];

			Assert.AreEqual(17, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Shipment.ShipmentGuid), TABLES.Shipment.ShipmentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Shipment.ShipmentDirection), TABLES.Shipment.ShipmentDirection);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Shipment.ShipmentDate), TABLES.Shipment.ShipmentDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Shipment.InvoiceNumber), TABLES.Shipment.InvoiceNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Shipment.DivisionCode), TABLES.Shipment.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Shipment.LastUpdateDate), TABLES.Shipment.LastUpdateDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Shipment.LastUpdateUser), TABLES.Shipment.LastUpdateUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Shipment.ShipmentTemperature), TABLES.Shipment.ShipmentTemperature);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Shipment.ShipmentTypeCode), TABLES.Shipment.ShipmentTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Shipment.RowVersion), TABLES.Shipment.RowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.LocalSupplier.FacilityName), TABLES.LocalSupplier.FacilityName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Address.AddressCity), TABLES.Address.AddressCity);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Address.StateCode), TABLES.Address.StateCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.LocalSupplier.LocalSupplierGuid), TABLES.LocalSupplier.LocalSupplierGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.LocalSupplier.FdaRegistrationNumber), TABLES.LocalSupplier.FdaRegistrationNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.LocalSupplier.PhoneNumber), TABLES.LocalSupplier.PhoneNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.LocalSupplier.FaxNumber), TABLES.LocalSupplier.FaxNumber);
		}

		[Test]
		public void GetOutgoingInvoiceByGuid_Fail()
		{
			Guid shipmentGuid = Guid.NewGuid();

			DataSet dsTest = DAL.OutgoingShipment.GetOutgoingInvoiceByGuid(shipmentGuid);
			DataTable dtTest = dsTest.Tables[0];

			Assert.IsTrue(dtTest.Rows.Count == 0);
		}

		[Test]
		public void GetRecentInvoicesForDivision_Pass()
		{
			DataTable dtTest = DAL.OutgoingShipment.GetRecentInvoicesForDivision();

			Assert.AreEqual(18, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Shipment.ShipmentGuid), TABLES.Shipment.ShipmentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Shipment.ShipmentDirection), TABLES.Shipment.ShipmentDirection);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Shipment.ShipmentDate), TABLES.Shipment.ShipmentDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Shipment.InvoiceNumber), TABLES.Shipment.InvoiceNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Shipment.DivisionCode), TABLES.Shipment.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Shipment.LastUpdateDate), TABLES.Shipment.LastUpdateDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Shipment.LastUpdateUser), TABLES.Shipment.LastUpdateUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Shipment.ShipmentTemperature), TABLES.Shipment.ShipmentTemperature);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Shipment.ShipmentTypeCode), TABLES.Shipment.ShipmentTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Shipment.RowVersion), TABLES.Shipment.RowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Shipment.RecordStatusCode), TABLES.Shipment.RecordStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.LocalSupplier.FacilityName), TABLES.LocalSupplier.FacilityName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Address.AddressCity), TABLES.Address.AddressCity);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Address.StateCode), TABLES.Address.StateCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.LocalSupplier.LocalSupplierGuid), TABLES.LocalSupplier.LocalSupplierGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.LocalSupplier.FdaRegistrationNumber), TABLES.LocalSupplier.FdaRegistrationNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.LocalSupplier.PhoneNumber), TABLES.LocalSupplier.PhoneNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.LocalSupplier.FaxNumber), TABLES.LocalSupplier.FaxNumber);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetRecentInvoicesForDivision_Fail()
		{
		}

		[Test]
		public void GetReportDataSet_Pass()
		{
			//This is commented out because the spOutgoingInovoiceReport2 sproc sucks like nothing has ever sucked before
			//Guid shipmentGuid = (Guid)this._dtShipment.Rows[0][TABLES.Shipment.ShipmentGuid];
			Guid shipmentGuid = Guid.NewGuid();

			DataSet dsTest = DAL.OutgoingShipment.GetReportDataSet(shipmentGuid);

			Assert.AreEqual(2, dsTest.Tables.Count, "Tables.Count");
			Assert.AreEqual(23, dsTest.Tables[0].Columns.Count, "Tables[0].Columns.Count");
			Assert.AreEqual(9, dsTest.Tables[1].Columns.Count, "Tables[1].Columns.Count");
		}

		[Test]
		public void GetReportDataSet_Fail()
		{
			Guid shipmentGuid = Guid.NewGuid();
			DataSet dsTest = DAL.OutgoingShipment.GetReportDataSet(shipmentGuid);

			Assert.AreEqual(0, dsTest.Tables[0].Rows.Count, "Tables.Count");
		}

		[Test]
		public void GetUnitsInInvoice_Pass()
		{
			Guid shipmentGuid = (Guid)this._dtShipment.Rows[0][TABLES.Shipment.ShipmentGuid];

			DataTable dtTest = DAL.OutgoingShipment.GetUnitsInInvoice(shipmentGuid);

			Assert.AreEqual(3, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodUnitGuid), TABLES.BloodUnit.BloodUnitGuid);
		}

		[Test]
		public void GetUnitsInInvoice_Fail()
		{
			Guid shipmentGuid = Guid.NewGuid();

			DataTable dtTest = DAL.OutgoingShipment.GetUnitsInInvoice(shipmentGuid);

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void RemoveAllUnitsFromInvoice_Pass()
		{
			this.RefreshData = true;

			Guid shipmentGuid = (Guid)this._dtShipment.Rows[0][TABLES.Shipment.ShipmentGuid];

			byte[] ShipmentRowVersion = (byte[])this._dtShipment.Rows[0][TABLES.Shipment.RowVersion];
			byte[] UnitStatusRowVersion = (byte[])this._dtBloodUnit.Rows[0]["UnitStatusRowVersion"];
			byte[] UnitRowVersion = (byte[])this._dtBloodUnit.Rows[0][TABLES.BloodUnit.RowVersion];
			byte[] BloodUnitShipmentRowVersion = (byte[])this._dtBloodUnitShipment.Rows[0]["RowVersion"];

			DataTable dtShipment=new DataTable();
			dtShipment.Columns.Add(Common.VbecsTables.Shipment.ShipmentGuid, typeof(Guid));
			dtShipment.Columns.Add(Common.VbecsTables.Shipment.RowVersion, typeof(byte[]));
			dtShipment.Columns.Add(Common.VbecsTables.Shipment.LastUpdateUser, typeof(string));
			dtShipment.Columns.Add(Common.VbecsTables.Shipment.LastUpdateFunctionId, typeof(int));

			DataRow dtRow=dtShipment.NewRow();
			dtRow[Common.VbecsTables.Shipment.ShipmentGuid]=shipmentGuid;
			dtRow[Common.VbecsTables.Shipment.LastUpdateUser]=Common.LogonUser.LogonUserName;
			dtRow[Common.VbecsTables.Shipment.LastUpdateFunctionId]= 4321;		//Custom functionid for rollback
			dtRow[Common.VbecsTables.Shipment.RowVersion] = ShipmentRowVersion;

			dtShipment.Rows.Add(dtRow);

			DataTable dtBloodUnitShipment=dtShipment.Clone();
			
			dtRow=dtBloodUnitShipment.NewRow();
			dtRow[Common.VbecsTables.Shipment.ShipmentGuid]=shipmentGuid;
			dtRow[Common.VbecsTables.Shipment.RowVersion]= BloodUnitShipmentRowVersion;
			dtRow[Common.VbecsTables.Shipment.LastUpdateUser]=Common.LogonUser.LogonUserName;
			dtRow[Common.VbecsTables.Shipment.LastUpdateFunctionId]=4321;		//Custom functionid for rollback
			dtBloodUnitShipment.Rows.Add(dtRow);

			DAL.OutgoingShipment.RemoveAllUnitsFromInvoice(dtShipment,dtBloodUnitShipment);
			Assert.AreEqual(true, true, "NoReturnValue");		//No return value

			//Set the data back the way it was-- at least the one record we know -- since it was a success
			int uCheck = UnitTestUtil.RunSQL("UPDATE BloodUnitShipment SET RecordStatusCode = 'A', LastUpdateFunctionId = 9999 WHERE OutgoingShipmentGuid = '" + shipmentGuid.ToString() + "' AND RecordStatusCode = 'X' AND LastUpdateFunctionId = 4321");
			uCheck = UnitTestUtil.RunSQL("UPDATE Shipment SET RecordStatusCode='A', LastUpdateFunctionId = 9999 WHERE ShipmentGuid = '" + shipmentGuid.ToString() + "' AND RecordStatusCode = 'X' AND LastUpdateFunctionId = 4321");
			
			Assert.AreEqual(true, true, "Data Rollback");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void RemoveAllUnitsFromInvoice_Fail()
		{
		}

		[Test]
		public void UpdateInvoiceText_Pass()
		{
			string invoiceText = System.DateTime.Now.ToString();
			gov.va.med.vbecs.BOL.Division division=new gov.va.med.vbecs.BOL.Division(Common.LogonUser.LogonUserDivisionCode);
			bool retValue = DAL.OutgoingShipment.UpdateInvoiceText(Common.LogonUser.LogonUserName, invoiceText, Common.UpdateFunction.UnitTests, division.RowVersion);

			Assert.AreEqual(true, retValue, "ReturnValue");

			//Dont care about the previous invoice text, it's probably null anyway
		}

		[Test]
		[ExpectedException(typeof(Common.RowVersionException))]
		public void UpdateInvoiceText_Fail()
		{
			string invoiceText = System.DateTime.Now.ToString();

			bool retValue = DAL.OutgoingShipment.UpdateInvoiceText(Common.LogonUser.LogonUserName, invoiceText, Common.UpdateFunction.UnitTests, new byte[8]);
		}

		
		[Test]
		public void GetShipmentInvoiceCount_Pass()
		{
			DataRow drData = UnitTestUtil.RunSQLGetDataRow("SELECT TOP 1 * FROM Shipment WHERE RecordStatusCode = 'A' AND DivisionCode = '" + this.TestDivisionCode + "'");

			string invoiceNumber = drData[TABLES.Shipment.InvoiceNumber].ToString();
			Guid lsGuid = (Guid)drData[TABLES.Shipment.LocalSupplierGuid];

			DataTable dtTest = UnitTestUtil.RunSQLGetDataTable("SELECT dbo.fnShipmentLogicalKey ( '" + this.TestDivisionCode + "', '" + lsGuid.ToString() + "', NULL,  '" + invoiceNumber + "', NULL, 0 )");

			int retValue = DAL.OutgoingShipment.GetShipmentInvoiceCount(lsGuid, invoiceNumber);

			Assert.AreEqual(System.Convert.ToInt32(dtTest.Rows[0][0]), retValue);
		}

		[Test]
		public void GetShipmentInvoiceCount_Fail()
		{
			int retValue = DAL.OutgoingShipment.GetShipmentInvoiceCount(Guid.NewGuid(), "FLEXO");

			Assert.AreEqual(0, retValue);
		}

	}
}
#endif
